import java.io.*;
import java.util.*;
import java.math.*;

public class D implements Runnable {
	private static BufferedReader in;
	private static StringTokenizer st;
	private static PrintWriter out;

	class Edge {
		int from, to;
		long length;
		int id;
		boolean inTree;

		Edge(int from, int to, long length, int id) {
			this.from = from;
			this.to = to;
			this.length = length;
			this.id = id;
			this.inTree = false;
		}
	}

	class Pair implements Comparable<Pair> {
		int vertex;
		long distance;

		Pair(int vertex, long distance) {
			this.vertex = vertex;
			this.distance = distance;
		}

		public int compareTo(Pair other) {
			return Long.compare(distance, other.distance);
		}
	}

	class VertexPair implements Comparable<VertexPair> {
		int u, v;

		public VertexPair(int u, int v) {
			if (u > v) {
				int t = u;
				u = v;
				v = t;
			}
			this.u = u;
			this.v = v;
		}

		public int compareTo(VertexPair other) {
			if (u != other.u)
				return Integer.compare(u, other.u);
			return Integer.compare(v, other.v);
		}

	}

	private long[] shortestPathes(int n, int from, List<Edge>[] g) {
		long[] distance = new long[n];
		final long INF = Long.MAX_VALUE / 128;
		Arrays.fill(distance, INF);
		distance[from] = 0;
		Queue<Pair> q = new PriorityQueue<>();
		q.add(new Pair(from, 0));
		while (!q.isEmpty()) {
			Pair p = q.poll();
			if (distance[p.vertex] == p.distance) {
				for (Edge e : g[p.vertex]) {
					long newDistance = p.distance + e.length;
					if (newDistance < distance[e.to]) {
						distance[e.to] = newDistance;
						q.add(new Pair(e.to, newDistance));
					}
				}
			}
		}
		return distance;
	}

	private void solve() throws IOException {
		int n = nextInt(), m = nextInt();
		Edge[] allEdges = new Edge[2 * m];
		List<Edge>[] g = new List[n];
		for (int i = 0; i < n; i++) {
			g[i] = new ArrayList<Edge>();
		}
		for (int i = 0; i < m; i++) {
			int u = nextInt() - 1, v = nextInt() - 1, length = nextInt();
			Edge first = new Edge(u, v, length, i + 1);
			Edge second = new Edge(v, u, length, i + 1);
			allEdges[2 * i] = first;
			allEdges[2 * i + 1] = second;
			g[u].add(first);
			g[v].add(second);
		}
		long[] normalP = shortestPathes(n, 0, g);
		long[] reverseP = shortestPathes(n, n - 1, g);
		long needResult = normalP[n - 1];
		Map<VertexPair, Integer> allEdgesInTree = new TreeMap<>();
		for (int i = 0; i < 2 * m; i++) {
			Edge e = allEdges[i];
			if (normalP[e.from] + e.length + reverseP[e.to] == needResult) {
				e.inTree = true;
				Edge reverse = allEdges[i ^ 1];
				reverse.inTree = true;
				VertexPair pair = new VertexPair(e.from, e.to);
				Integer before = allEdgesInTree.get(pair);
				if (before == null)
					before = 0;
				allEdgesInTree.put(pair, before + 1);
			}
		}
		boolean[] used = new boolean[n];
		int[] timeIn = new int[n];
		int[] timeOut = new int[n];
		Set<Integer> badIds = new TreeSet<>();
		timer = 1;
		for (int i = 0; i < n; i++) {
			if (!used[i]) {
				dfs(i, -1, g, used, timeIn, timeOut, badIds, allEdgesInTree);
			}
		}
		out.println(badIds.size());
		for (int id : badIds) {
			out.print(id + " ");
		}
		out.println();
	}

	int timer;

	private void dfs(int u, int p, List<Edge>[] g, boolean[] used,
			int[] timeIn, int[] timeOut, Set<Integer> badIds,
			Map<VertexPair, Integer> count) {
		used[u] = true;
		timeIn[u] = timeOut[u] = timer++;
		for (Edge e : g[u]) {
			if (e.inTree) {
				int v = e.to;

				if (v == p)
					continue;

				if (!used[v]) {
					dfs(v, u, g, used, timeIn, timeOut, badIds, count);

					if (timeIn[u] < timeOut[v]
							&& count.get(new VertexPair(u, v)) == 1) {
						badIds.add(e.id);
					}

					timeOut[u] = Math.min(timeOut[u], timeOut[v]);
				} else {
					timeOut[u] = Math.min(timeOut[u], timeIn[v]);
				}
			}
		}
	}

	public void run() {
		final String className = this.getClass().getName().toLowerCase();

		try {
			try {
				in = new BufferedReader(new FileReader(className + ".in"));
				out = new PrintWriter(new FileWriter(className + ".out"));
			} catch (FileNotFoundException e) {
				in = new BufferedReader(new InputStreamReader(System.in));
				out = new PrintWriter(System.out);
			}

			solve();

			out.close();
		} catch (IOException e) {
			e.printStackTrace();
			System.exit(1);
		}
	}

	public static void main(String[] args) {
		new D().run();
		// new Thread(null, new Template(), "Template", (1L << 24)).start();
	}

	private String nextToken() throws IOException {
		while (st == null || !st.hasMoreTokens()) {
			String line = in.readLine();
			if (line == null) {
				return null;
			}
			st = new StringTokenizer(line);
		}
		return st.nextToken();
	}

	private int nextInt() throws IOException {
		return Integer.parseInt(nextToken());
	}

	private long nextLong() throws IOException {
		return Long.parseLong(nextToken());
	}

	private double nextDouble() throws IOException {
		return Double.parseDouble(nextToken());
	}

}
